# Повышение скорости
Скорость выполнения удвоилась. Проблема в том, что теперь дрон производит сбор быстрее, чем растет трава, а это приводит к отсутствию урожая. Для решения разблокированы ветвление [if](docs/scripting/if.md) и функция [can_harvest](functions/can_harvest).

## Проверка перед сбором урожая
До сих пор в качестве условий у нас были только `True` и `False`. Конечно, для инструкции `if` они не подойдут.

Новая функция `can_harvest()` лучше подойдет в качестве условия. `can_harvest()` возвращает `True`, если под дроном можно собрать урожай, в противном случае — `False`.

`if can_harvest():
	#сделать что-то`

Эту функцию можно использовать как условие, поскольку она возвращает логическое значение.

Возвращаемое значение, по сути, означает, что после выполнения функции ее вызывающее выражение вычисляется как возвращенное значение.

Что происходит, когда выполняется приведенный выше код:
	- Выполняется if.
	- Вызывается `can_harvest()`.
	- `can_harvest()` выполняет свое назначение.
	- `can_harvest()` возвращает `True` или `False`.
	- Теперь инструкция получает вид `if True:` или `if False:`.
	- Блок кода выполняется, только если можно собрать урожай.

Теперь можно использовать `if`, чтобы дрон не собирал урожай слишком рано.